%   Copyright  2020 University of Extremadura (UEx)
%
% loadDeploymentRss
%
%  Input:
%   set: Current deployment information 
%   rssMatrix: RSSI presented as RSSI fingerprinting matrix. Each row is a
%   RP point and each column is a beacon (Slot)
%   coordMatrix: Coordinates of the reference points in the before matrix
%   as x y z.
%   idxRadioMap: indexes with the propoused split between train and test 
%   idxEval: indexes with the propoused split between train and test 
%
%  Output:
%   data: Structure with the selected data
% -----------------------------------------

function [rssTrnMat,rssTstMat,zoneTrnMat,zoneTstMat] = splitTrnTst_fromMatrix_withIdx_zone(set,rssMatrix,zoneMatrix,idxRadioMap,idxEval)


% Output matrix are crated
rssTrnMat = zeros(sum(idxRadioMap),size(rssMatrix,2));
rssTstMat = zeros(sum(idxEval),size(rssMatrix,2));
zoneTrnMat = zeros(sum(idxRadioMap),1);
zoneTstMat = zeros(sum(idxEval),1);

% Original matrix is divided into test and traning matrix
rssTrnMat =  rssMatrix(logical(idxRadioMap),:);
rssTstMat =  rssMatrix(logical(idxEval),:);
zoneTrnMat = zoneMatrix(logical(idxRadioMap),:);
zoneTstMat = zoneMatrix(logical(idxEval),:);
end

